<?php

namespace Drupal\commerce_credibanco\PluginForm\OffsiteRedirect;

use Drupal\commerce_payment\PluginForm\PaymentOffsiteForm as BasePaymentOffsiteForm;
use Drupal\commerce_price\Calculator;
use Drupal\commerce_price\Entity\Currency;
use Drupal\commerce_price\Price;
use Drupal\commerce_credibanco\CommerceCredibanCoPaymentApi;
use Drupal\Core\Form\FormStateInterface;
use Drupal\commerce_order\Entity\Order;
use Drupal\commerce_order\Entity\OrderItem;

use Drupal\commerce_order\Entity\OrderItemInterface;
use Drupal\commerce_tax\TaxableType;
use Drupal\commerce_tax\TaxZone;
use Drupal\commerce_tax\Plugin\Commerce\TaxType;


class PaymentOffsiteForm extends BasePaymentOffsiteForm
{

    /**
     * {@inheritdoc}
     */
    public function buildConfigurationForm(array $form, FormStateInterface $form_state)
    {
        $form = parent::buildConfigurationForm($form, $form_state);

        /** @var \Drupal\commerce_payment\Entity\PaymentInterface $payment */
        $payment = $this->entity;
        /** @var \Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\OffsitePaymentGatewayInterface $payment_gateway_plugin */
        $payment_gateway_plugin = $payment->getPaymentGateway()->getPlugin();

        $data = [];

        $payment_gateway_configuration = $payment_gateway_plugin->getConfiguration();

        $params['userName'] = $payment_gateway_configuration['username'];
        $params['password'] = $payment_gateway_configuration['password'];
        $params['isDoubleStaged'] = $payment_gateway_configuration['double_staged'] == 0 ? false : true;
        $params['isTestMode'] = $payment_gateway_configuration['mode'] == 'live' ? false : true;
        $params['isLogging'] = $payment_gateway_configuration['logging'] == 0 ? false : true;

        $jsonParams_array = array();

        $order = $payment->getOrder();
        $dp_items = $order->getItems();

        $iva_amount_total = 0;
        $iac_amount_total = 0;

        // Loop through order tax items
        foreach ($dp_items as $key => $value) {

//            $itemPrice = round($value->getUnitPrice()->getNumber(), 2) * 100;

            foreach ($value->getAdjustments() as $k => $v) {

                $tax_data['tax'] = $v->getType();
                $tax_data['amount'] = $v->getAmount()->getNumber();
                $tax_data['sourceId'] = $v->getSourceId();

                $s = explode("|", $tax_data['sourceId']);

                if ($s[0] == "iva") {
                    $iva_amount_total += $tax_data['amount'] * 100;
                }

                if ($s[0] == "iac") {
                    $iac_amount_total += $tax_data['amount'] * 100;
                }
            }
        }

        if (!empty($order->getEmail())) {
            $jsonParams_array['email'] = $order->getEmail();
        }

        // Build data for the request.
        $billingAddress = $order->getBillingProfile()->address->first()->toArray();

//        $address['country_code']; //=> RU
//        $address['administrative_area']; // => Moskva
//        $address['locality']; // => Moscow
//        $address['postal_code']; // => 117115
//        $address['address_line1'];// => Main Street 1
//        $address['given_name']; // => FIRSTANAME
//        $address['family_name']; // => LASTNAME

//        if (!empty($order_info['telephone'])) {
//            $jsonParams_array['phone'] = "+" . preg_match('/[7]\d{9}/', $order_info['telephone']) ? $order_info['telephone'] : '';
//        }

        if (!empty($billingAddress['address_line1'])) {
            $jsonParams_array['postAddress'] = $billingAddress['address_line1'];
        }
        if (!empty($billingAddress['administrative_area'])) {
            $jsonParams_array['payerCity'] = $billingAddress['administrative_area'];
        }
        if (!empty($billingAddress['country_code'])) {
            $jsonParams_array['payerState'] = $billingAddress['country_code'];
        }
        if (!empty($billingAddress['postal_code'])) {
            $jsonParams_array['payerPostalCode'] = $billingAddress['postal_code'];
        }
        if (!empty($billingAddress['country_code'])) {
            $jsonParams_array['payerCountry'] = $billingAddress['country_code'];
        }

        //custom field name field_telephone
        $field_telephone = $order->getBillingProfile()->field_telephone->value;
        if (!empty($field_telephone)) {
            $jsonParams_array['phone'] = "+" . preg_replace("/(\W*)/", "", $field_telephone);
        }

        ($iva_amount_total > 0) ? $jsonParams_array["IVA.amount"] = round($iva_amount_total) : false;
        ($iac_amount_total > 0) ? $jsonParams_array["IAC.amount"] = round($iac_amount_total) : false;

        $params['jsonParams'] = $jsonParams_array;

        $commerceCredibanCoPaymentApi = new CommerceCredibanCoPaymentApi($params);

        $amount = $payment->getOrder()->getTotalPrice();
        $payment->save();

        $this->_updateGateSettings($commerceCredibanCoPaymentApi, $params['isTestMode'], $form["#return_url"]);

        $response = $commerceCredibanCoPaymentApi->registerOrder(
            $payment->id(),
            $this->toMinorUnits($amount),
            $form["#return_url"]
//            $form['#exception_url']
        );

        if (!isset($response['errorCode'])) {
            $redirect_url = $response['formUrl'];
            $payment->setRemoteId($response['orderId']);
            $payment->save();
            return $this->buildRedirectForm($form, $form_state, $redirect_url, $data, self::REDIRECT_GET);

        } else {
            drupal_set_message(t('Error # %code: %message', [
                '%code' => $response['errorCode'],
                '%message' => $response['errorMessage']]), 'error');
//            $redirect_url = $form['#exception_url'];
        }
    }

    public function _updateGateSettings($commerceCredibanCoPaymentApi, $testMode, $callback_addresses_string)
    {
        $action_adr = $testMode ? CommerceCredibanCoPaymentApi::test_API_URL : CommerceCredibanCoPaymentApi::production_API_URL;

        $callback_addresses_string .= "?callback=true";

        $login = $commerceCredibanCoPaymentApi->getUserName();
        $password = $commerceCredibanCoPaymentApi->getPassword();

        $gate_url = str_replace("payment/rest", "mportal/mvc/public/merchant/update", $action_adr);
        $gate_url .= substr($login, 0, -4); // we guess username = login w/o "-api"

        $headers = array(
            'Content-Type:application/json',
            'Authorization: Basic ' . base64_encode($login . ":" . $password)
        );

        $data['callbacks_enabled'] = true;
        $data['callback_operations'] = "deposited,approved,declinedByTimeout";
        $data['callback_addresses'] = $callback_addresses_string;

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_VERBOSE => true,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_URL => $gate_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_ENCODING, "gzip",
            CURLOPT_ENCODING, '',
        ));
        $response = curl_exec($ch);

        \Drupal::logger('commerce_credibanco')->warning('Try to SET callback_addresses, message = "%message", <br/> POST: %post', array(
//            '%error_code' => $errorCode,
            '%message' => $response,
            '%post' => json_encode($data),
        ));
    }

    /**
     * Converts the given amount to its minor units.
     *
     * For example, 9.99 USD becomes 999.
     *
     * @param \Drupal\commerce_price\Price $amount
     *   The amount.
     *
     * @return int
     *   The amount in minor units, as an integer.
     */
    protected function toMinorUnits(Price $amount)
    {
        /** @var \Drupal\commerce_price\Entity\CurrencyInterface $currency */
        $currency = Currency::load($amount->getCurrencyCode());
        $fraction_digits = $currency->getFractionDigits();
        $number = $amount->getNumber();
        if ($fraction_digits > 0) {
            $number = Calculator::multiply($number, pow(10, $fraction_digits));
        }

        return round($number, 0);
    }

    /**
     * @param string $currency_code
     *
     * @return string
     */
    function getCurrencyNumericCode($currency_code)
    {
        $currency = Currency::load($currency_code);
        return $currency->getNumericCode();
    }
}