<?php

namespace RBS\CredibanCo\Controller\Url;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Sales\Model\Order;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\DataObjectFactory;
use Magento\Sales\Model\Order\Payment;
use Magento\Sales\Model\OrderRepository as MageOrderRepository;
use Magento\Catalog\Model\Product;
use Magento\Tax\Model\Calculation\Rate;
use Magento\Sales\Model\ResourceModel\Order\Tax\Item;

class RbsCurl extends Action implements CsrfAwareActionInterface
{
    /** @var \Magento\Framework\View\Result\PageFactory */
    protected $resultPageFactory;

    protected $_encryptor;
    protected $_urlBuilder;
    protected $_logger;
    protected $orderRepository;
    protected $module_version_str = "1.1.1";

    protected $credibanco_form;
    protected $_taxModelConfig;


    public function __construct(
        Context $context,
        \Magento\Payment\Model\Method\Logger $logger,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Encryption\EncryptorInterface $encryptor,
        \Magento\Framework\App\ResponseFactory $responseFactory,
        \Magento\Framework\UrlInterface $urlBuilder,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \RBS\CredibanCo\Block\Widget\Redirect $credibanco_form,
        \RBS\CredibanCo\Logger\Logger $customLogger
    )
    {
        parent::__construct($context);
        $this->_encryptor = $encryptor;
        $this->resultPageFactory = $resultPageFactory;
        $this->_responseFactory = $responseFactory;
        $this->_urlBuilder = $urlBuilder;
        $this->orderRepository = $orderRepository;
        $this->_logger = $logger;
        $this->credibanco_form = $credibanco_form;
        $this->_customLogger = $customLogger;
    }


    /**
     * Load the page defined
     *
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {

        // load model
        /* @var $paymentMethod \Magento\Authorizenet\Model\DirectPost */
        $paymentMethod = $this->_objectManager->create('RBS\CredibanCo\Model\CredibanCo');
        $post_data = $this->credibanco_form->getPostData();

        // try update callback_addresses
        $loginAPI = $paymentMethod->getConfigData("RBS_MERCHANT_LOGIN");
        $userPassword = $this->_encryptor->decrypt($paymentMethod->getConfigData("RBS_MERCHANT_PASSWORD"));
        $returnUrl = $this->_urlBuilder->getUrl('credibanco/url/success');

        $gate_url = str_replace ( "payment/rest", "mportal/mvc/public/merchant/update", $paymentMethod->getGateUrl(false));
        $gate_url .= substr($loginAPI, 0, -4); // we guess username = login w/o "-api"
        $callback_addresses_string = $this->_urlBuilder->getUrl('credibanco/url/callback');
        $this->updateRBSCallback($loginAPI, $userPassword, $gate_url, $callback_addresses_string);


        // Detect the version of this CMS
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $productMetadata = $objectManager->get('Magento\Framework\App\ProductMetadataInterface');
        $version = $productMetadata->getVersion();

        $args['orderNumber'] = $post_data['order_id'] . "#" . time();
        $args['description'] = __("Pay order №") . $post_data['order_id'];
        $args['userName'] = $loginAPI;
        $args['password'] = $userPassword;
        $args['returnUrl'] = $returnUrl;
        $args['amount'] = $post_data['amount']; //already comes from other place =) * 100;

        $jsonParams_array = array(
            'CMS:' => 'Magento ' . $version,
            'Module-Version: ' => 'CredibanCo ' . $this->module_version_str,
        );

        $rbs_items = array();

        $order = $this->_objectManager->create('Magento\Sales\Model\Order')->loadByIncrementId($post_data['order_id']);

        $cn = 1;
        $iva_amount_total = 0;
        $iac_amount_total = 0;

        foreach ($order->getAllVisibleItems() as $item) {

            $item_data = $item->getData();

            $rbs_item_price = ceil($item_data['price'] * 100);

            $item_rate = (int)$item_data['tax_percent'];
            $rbs_item_tax_type = 0;
            switch ($item_rate) {
                case 20:
                    $rbs_item_tax_type = 6;
                    break;
                case 18:
                    $rbs_item_tax_type = 3;
                    break;
                case 10:
                    $rbs_item_tax_type = 2;
                    break;
                case 0:
                    $rbs_item_tax_type = 1;
                    break;
            }

            $rbs_item['positionId'] = $cn;
            $rbs_item['name'] = $item_data['name'];
            $rbs_item['quantity'] = array(
                'value' => round($item_data['qty_ordered'], 2),
                'measure' => 'piece'
            );
            $rbs_item['itemAmount'] = $rbs_item_price * $item_data['qty_ordered'];
            $rbs_item['itemCode'] = $item_data['product_id'];
            $rbs_item['tax'] = array(
                'taxType' => $rbs_item_tax_type
            );
            $rbs_item['itemPrice'] = $rbs_item_price;
            $cn++;

            $attributes = array();
            $attributes[] = array(
                "name" => "paymentMethod",
                "value" => $paymentMethod->getConfigData('ffd_paymentMethodType')
            );
            $attributes[] = array(
                "name" => "paymentObject",
                "value" => $paymentMethod->getConfigData('ffd_paymentObjectType')
            );
            $rbs_item['itemAttributes']['attributes'] = $attributes;

            $rbs_items[] = $rbs_item;
        }

        // TAX FOR CURRENT ORDER
        $tax_items = $objectManager->create('\Magento\Sales\Model\ResourceModel\Order\Tax\Item')->getTaxItemsByOrderId($order->getId());

        foreach ($tax_items as $tax_item) {
            if (strtolower($tax_item['title']) == "iva") {
                $iva_amount_total += $tax_item['real_amount'];
            }
            if (strtolower($tax_item['title']) == "iac") {
                $iac_amount_total += $tax_item['real_amount'];
            }
        }

        ($iva_amount_total > 0) ? $jsonParams_array["IVA.amount"] = $iva_amount_total * 100 : false;
        ($iac_amount_total > 0) ? $jsonParams_array["IAC.amount"] = $iac_amount_total * 100 : false;

        // GET ORDER DETAILS
        $shipping_address = $order->getShippingAddress();
        $billing_address = $order->getBillingAddress();

        if (!empty($billing_address['email'])) {
            $jsonParams_array['email'] = $billing_address['email'];
        }
        if (!empty($billing_address['telephone'])) {
            $jsonParams_array['phone'] = "+".preg_replace("/(\W*)/", "", $billing_address['telephone']);
        }

        if (!empty($billing_address['street'])) {
            $jsonParams_array['postAddress'] = $billing_address['street'];
        }
        if (!empty($billing_address['city'])) {
            $jsonParams_array['payerCity'] = $billing_address['city'];
        }
        if (!empty($billing_address['state'])) {
            $jsonParams_array['payerState'] = $billing_address['state'];
        }
        if (!empty($billing_address['postcode'])) {
            $jsonParams_array['payerPostalCode'] = $billing_address['postcode'];
        }
        if (!empty($billing_address['country_id'])) {
//            $country = $objectManager->create('\Magento\Directory\Model\Country')->load($billing_address['country_id'])->getName();
            $jsonParams_array['payerCountry'] = $billing_address['country_id'];
        }

        if (!empty($shipping_address['street'])) {
            $jsonParams_array['shippingAddress'] = $shipping_address['street'];
        }
        if (!empty($shipping_address['email'])) {
            $jsonParams_array['shippingContactEmail'] = $shipping_address['email'];
        }
        if (!empty($shipping_address['telephone'])) {
            $jsonParams_array['shippingContactPhone'] = "+".preg_replace("/(\W*)/", "", $shipping_address['telephone']);
        }

        $args['jsonParams'] = json_encode($jsonParams_array);

        $rbsCurl = curl_init();
        $action_url = $paymentMethod->getGateUrl();
        curl_setopt_array($rbsCurl, array(
                CURLOPT_HTTPHEADER => array(
                    'CMS: Magento ' . $version,
                    'Module-Version: CredibanCo ' . $this->module_version_str
                ),
                CURLOPT_URL => $action_url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $args, '', '&')
        );

        $response = curl_exec($rbsCurl);
//        print_r($response);die;
        curl_close($rbsCurl);

        $this->_customLogger->info("[REQUEST] " . json_encode($args));
        $this->_customLogger->info("[RESPONSE] " . $response);

        $response = json_decode($response, true);


        $CustomRedirectionUrl = $this->_urlBuilder->getUrl($response['formUrl']);
        $this->_responseFactory->create()->setRedirect($CustomRedirectionUrl)->sendResponse();

        exit();

    }

    /**
     * Create exception in case CSRF validation failed.
     * Return null if default exception will suffice.
     *
     * @param RequestInterface $request
     *
     * @return InvalidRequestException|null
     * @SuppressWarnings(PMD.UnusedFormalParameter)
     */
    public function createCsrfValidationException(RequestInterface $request): ?InvalidRequestException
    {
        return null;
    }

    /**
     * Perform custom request validation.
     * Return null if default validation is needed.
     *
     * @param RequestInterface $request
     *
     * @return bool|null
     * @SuppressWarnings(PMD.UnusedFormalParameter)
     */
    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }


    public function updateRBSCallback($login, $password, $gate_url, $callback_addresses_string) {

        $headers = array(
            'Content-Type:application/json',
            'Authorization: Basic ' . base64_encode($login . ":" . $password)
        );

        $data['callbacks_enabled'] = true;
        $data['callback_addresses'] = $callback_addresses_string;
        $data['callback_operations'] = "deposited,approved";

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_VERBOSE => true,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_URL => $gate_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_ENCODING, "gzip",
            CURLOPT_ENCODING, '',
        ));
        $response = curl_exec($ch);
    }

}
