<?php

class ControllerExtensionPaymentCredibanco extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('extension/payment/credibanco');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('payment_credibanco', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $test_mode = ($this->request->post['payment_credibanco_mode'] == 'test') ? true : false;
            $this->_updateGateSettings($test_mode);

            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', 'SSL'));
        }

        $data['heading_title'] = $this->language->get('heading_title');

        $data['breadcrumbs'] = array();
        array_push($data['breadcrumbs'],
            array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
            ),
            array(
                'text' => $this->language->get('text_payment'),
                'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', 'SSL')
            ),
            array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/payment/credibanco', 'user_token=' . $this->session->data['user_token'], 'SSL')
            )
        );

        $data['action'] = $this->url->link('extension/payment/credibanco', 'user_token=' . $this->session->data['user_token'], 'SSL');
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', 'SSL');
        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        $data['text_settings'] = $this->language->get('text_settings');

        $data['entry_status'] = $this->language->get('status');
        $data['status_enabled'] = $this->language->get('status_enabled');
        $data['status_disabled'] = $this->language->get('status_disabled');
//        $data['payment_credibanco_status'] = $data['payment_credibanco_status'] = $this->config->get('payment_credibanco_status');

        if (isset($this->request->post['payment_credibanco_status'])) {
            $data['payment_credibanco_status'] = $this->request->post['payment_credibanco_status'];
        } else {
            $data['payment_credibanco_status'] = $this->config->get('payment_credibanco_status');
        }

        $data['entry_merchantLogin'] = $this->language->get('merchantLogin');
        $data['payment_credibanco_merchantLogin'] = $this->config->get('payment_credibanco_merchantLogin');

        $data['entry_merchantPassword'] = $this->language->get('merchantPassword');
        $data['payment_credibanco_merchantPassword'] = $this->config->get('payment_credibanco_merchantPassword');

        $data['entry_mode'] = $this->language->get('mode');
        $data['mode_test'] = $this->language->get('mode_test');
        $data['mode_prod'] = $this->language->get('mode_prod');
        $data['payment_credibanco_mode'] = $this->config->get('payment_credibanco_mode');

        $data['entry_stage'] = $this->language->get('stage');
        $data['stage_one'] = $this->language->get('stage_one');
        $data['stage_two'] = $this->language->get('stage_two');
        $data['payment_credibanco_stage'] = $this->config->get('payment_credibanco_stage');

        $data['entry_order_status'] = $this->language->get('entry_order_status');

        if (isset($this->request->post['credibanco_order_status_id'])) {
            $data['payment_credibanco_order_status_id'] = $this->request->post['payment_credibanco_order_status_id'];
        } else {
            $data['payment_credibanco_order_status_id'] = $this->config->get('payment_credibanco_order_status_id');
        }

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $data['entry_sortOrder'] = $this->language->get('entry_sortOrder');
//        $data['payment_credibanco_sort_order'] = $this->config->get('payment_credibanco_sort_order');

        if (isset($this->request->post['payment_credibanco_sort_order'])) {
            $data['payment_credibanco_sort_order'] = $this->request->post['payment_credibanco_sort_order'];
        } else {
            $data['payment_credibanco_sort_order'] = $this->config->get('payment_credibanco_sort_order');
        }


        $data['entry_logging'] = $this->language->get('logging');
        $data['logging_enabled'] = $this->language->get('logging_enabled');
        $data['logging_disabled'] = $this->language->get('logging_disabled');
        $data['payment_credibanco_logging'] = $this->config->get('payment_credibanco_logging');

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

//        print_r($this->config);
//        echo "<hr>";
//        print_r($data);die;

        $this->response->setOutput($this->load->view('extension/payment/credibanco', $data));
    }

    /**
     * @return bool
     */
    private function validate()
    {
        if (!$this->user->hasPermission('modify', 'extension/payment/credibanco')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }


//http://oc23.onemanteam.ru/index.php?route=extension/payment/credibanco/comeback&orderId=39139f15-1767-7822-86ed-1c8b00abd060&lang=es

    public function _updateGateSettings($test_mode = true)
    {
        $this->library('credibanco');
        $credibanco = new Credibanco();

        $this->library('log');
        $file_name = date("y-m-d") . "_credibanco.log";
        $logger = new Log($file_name);

        // Endpoints
        $action_adr = $credibanco->prod_url;
        if ($test_mode) {
            $action_adr = $credibanco->test_url;
        }

//        $callback_addresses_string = HTTP_CATALOG .'extension/payment/credibanco/callback';

        $url = new Url(HTTP_CATALOG, $this->config->get('config_secure') ? HTTP_CATALOG : HTTPS_CATALOG);
        $callback_addresses_string = $url->link('extension/payment/credibanco/callback');

        $login = $this->config->get('payment_credibanco_merchantLogin');
        $password = $this->config->get('payment_credibanco_merchantPassword');

        $gate_url = str_replace("payment/rest", "mportal/mvc/public/merchant/update", $action_adr);
        $gate_url .= substr($login, 0, -4); // we guess username = login w/o "-api"

        $headers = array(
            'Content-Type:application/json',
            'Authorization: Basic ' . base64_encode($login . ":" . $password)
        );

        $data['callbacks_enabled'] = true;
        $data['callback_operations'] = "deposited,approved,declinedByTimeout";
        $data['callback_addresses'] = $callback_addresses_string;

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_VERBOSE => true,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_URL => $gate_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_ENCODING, "gzip",
            CURLOPT_ENCODING, '',
        ));
        $response = curl_exec($ch);

        $logger->write("\nREQUEST: " . json_encode($data) . "\n");
        $logger->write("\nRESPONSE: " . json_encode($response) . "\n");
    }

    private function library($library)
    {
        $file = DIR_SYSTEM . 'library/' . str_replace('../', '', (string)$library) . '.php';

        if (file_exists($file)) {
            include_once($file);
        } else {
            trigger_error('Error: Could not load library ' . $file . '!');
            exit();
        }
    }
}