<?php
ini_set('serialize_precision', 14);
ini_set('precision', 14);

class ControllerExtensionPaymentCredibanco extends Controller
{

    public $credibanco;

    /**
     * @param $registry
     */
    public function __construct($registry)
    {
        parent::__construct($registry);
        $this->load->language('extension/payment/credibanco');
        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/extension/payment/credibanco_n.twig')) {
            $this->have_template = true;
        }
    }

    /**
     * @return mixed
     */
    public function index()
    {
        $data['action'] = $this->url->link('extension/payment/credibanco/payment', '', true);
        $data['credibanco_button_confirm'] = $this->language->get('credibanco_button_confirm');
        return $this->get_template('extension/payment/credibanco', $data);
    }

    /**
     * @param $template
     * @param $data
     * @return mixed
     */
    private function get_template($template, $data)
    {
        return $this->load->view($template, $data);
    }

    public function payment()
    {

        $this->initializeRbs();

        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
        $order_number = (int)$order_info['order_id'];
        $amount = round($order_info['total'], 2) * 100;
        $return_url = $this->url->link('extension/payment/credibanco/comeback');

        $jsonParams_array = array(
            'CMS' => 'Opencart 3.x',
            'Module-Version' => 'CredibanCo ' . $this->credibanco->version,
        );

        if (!empty($order_info['email'])) {
            $jsonParams_array['email'] = $order_info['email'];
        }
        if (!empty($order_info['telephone'])) {
            $jsonParams_array['phone'] = "+" . preg_match('/[7]\d{9}/', $order_info['telephone']) ? $order_info['telephone'] : '';
        }

        if (!empty($order_info['payment_address_1'])) {
            $jsonParams_array['postAddress'] = $order_info['payment_address_1'];
        }
        if (!empty($order_info['payment_city'])) {
            $jsonParams_array['payerCity'] = $order_info['payment_city'];
        }
        if (!empty($order_info['payment_zone'])) {
            $jsonParams_array['payerState'] = $order_info['payment_zone'];
        }
        if (!empty($order_info['payment_postcode'])) {
            $jsonParams_array['payerPostalCode'] = $order_info['payment_postcode'];
        }
        if (!empty($order_info['payment_iso_code_2'])) {
            $jsonParams_array['payerCountry'] = $order_info['payment_iso_code_2'];
        }

        if (!empty($order_info['shipping_address_1'])) {
            $jsonParams_array['shippingAddress'] = $order_info['shipping_address_1'];
        }

        $iva_amount_total = $iac_amount_total = 0;

        foreach ($this->cart->getProducts() as $product) {

            $tax_rates = $this->tax->getRates($product['price'], $product['tax_class_id']);

            foreach ($tax_rates as $k => $v) {
                if (strtolower($v['name']) == "iva") {
                    $iva_amount_total += $this->tax->getTax($product['price'], $product['tax_class_id']) * $product['quantity'];
                }
                if (strtolower($v['name']) == "iac") {
                    $iac_amount_total += $this->tax->getTax($product['price'], $product['tax_class_id']) * $product['quantity'];
                }
            }
        }
        ($iva_amount_total > 0) ? $jsonParams_array["IVA.amount"] = $iva_amount_total * 100 : false;
        ($iac_amount_total > 0) ? $jsonParams_array["IAC.amount"] = $iac_amount_total * 100 : false;

//        $currency_code = $this->credibanco->currency_code2num[$order_info['currency_code']];

        // prepare args array
        $args = array(
            'orderNumber' => $order_number . "_" . time(),
            'amount' => $amount,
            'language' => 'es', //$language,
            'returnUrl' => $return_url,
//                'currency' => $this->currency_codes[get_woocommerce_currency()],
            'jsonParams' => json_encode($jsonParams_array),
        );

        $response = $this->credibanco->gateway($this->credibanco->stage == 'two' ? 'registerPreAuth.do' : 'register.do', $args);

        if (isset($response['errorCode'])) {
            $this->document->setTitle($this->language->get('error_title'));

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['column_right'] = $this->load->controller('common/column_right');
            $data['content_top'] = $this->load->controller('common/content_top');
            $data['button_continue'] = $this->language->get('error_continue');

            $data['heading_title'] = $this->language->get('error_title') . ' #' . $response['errorCode'];
            $data['text_error'] = $response['errorMessage'];
            $data['continue'] = $this->url->link('checkout/cart');

            $data['content_bottom'] = $this->load->controller('common/content_bottom');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->get_template('error/credibanco', $data));
        } else {
            $this->response->redirect($response['formUrl']);
        }
    }

    private function initializeRbs()
    {
        $this->library('credibanco');
        $this->credibanco = new Credibanco();
        $this->credibanco->login = $this->config->get('payment_credibanco_merchantLogin');
        $this->credibanco->password = $this->config->get('payment_credibanco_merchantPassword');
        $this->credibanco->stage = $this->config->get('payment_credibanco_stage');
        $this->credibanco->mode = $this->config->get('payment_credibanco_mode');
        $this->credibanco->logging = $this->config->get('payment_credibanco_logging');
    }

    /**
     * @param $library
     */
    private function library($library)
    {
        $file = DIR_SYSTEM . 'library/' . str_replace('../', '', (string)$library) . '.php';

        if (file_exists($file)) {
            include_once($file);
        } else {
            trigger_error('Error: Could not load library ' . $file . '!');
            exit();
        }
    }

// /index.php?route=extension/payment/credibanco/comeback&orderId=1f4c0b12-8523-703d-ba1d-083000abd060&lang=es
    public function comeback()
    {
        if (isset($this->request->get['orderId'])) {
            $order_id = $this->request->get['orderId'];
        } else {
            die('Illegal Access');
        }
        $this->initializeRbs();
        $response = $this->credibanco->get_order_status($order_id);

        $ex = explode("_", $response['orderNumber']);
        $order_number = $ex[0];

        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($order_number);

        if ($order_info) {
            if (($response['errorCode'] == 0) && (($response['orderStatus'] == 1) || ($response['orderStatus'] == 2))) {
                $this->response->redirect($this->url->link('checkout/success', '', true));
            } else {
                $this->response->redirect($this->url->link('checkout/failure', '', true));
            }
        }
    }


// /index.php?route=extension/payment/credibanco/callback&mdOrder=1f4c0b12-8523-703d-ba1d-083000abd060
    public function callback()
    {

        if (isset($this->request->get['mdOrder'])) {
            $order_id = $this->request->get['mdOrder'];
        } else {
            die('Illegal Access');
        }
        $this->initializeRbs();
        $response = $this->credibanco->get_order_status($order_id);

        $ex = explode("_", $response['orderNumber']);
        $order_number = $ex[0];

        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($order_number);

        if ($order_info) {
            if (($response['errorCode'] == 0) && (($response['orderStatus'] == 1) || ($response['orderStatus'] == 2))) {
                // set order status
                $this->model_checkout_order->addOrderHistory($order_number, $this->config->get('payment_credibanco_order_status_id'));
                $this->response->redirect($this->url->link('checkout/success', '', true));
            } else {
                $this->model_checkout_order->addOrderHistory($order_number, 1);
                $this->response->redirect($this->url->link('checkout/failure', '', true));
            }
        }
    }
}