<?php

define('RBS_CREDIBANCO_PAYMENT_NAME', 'CredibanCo');

define('RBS_CREDIBANCO_TEST_URL' , 'https://ecouat.credibanco.com/payment/rest/');
define('RBS_CREDIBANCO_PROD_URL' , 'https://eco.credibanco.com/payment/rest/');

define('RBS_CREDIBANCO_TEST_URL_PROXY' , 'https://ecouat.credibanco.com/proxy/rest/');
define('RBS_CREDIBANCO_PROD_URL_PROXY' , 'https://eco.credibanco.com/proxy/rest/');


define('RBS_CREDIBANCO_ENABLE_LOGGING', true);
define('RBS_CREDIBANCO_EXT_FIELDS', false);
define('RBS_CREDIBANCO_MEASUREMENT_NAME', "p");


//define('RBS_CREDIBANCO_TYPE', "normal");
//define('RBS_CREDIBANCO_TYPE', "restaurante");
define('RBS_CREDIBANCO_TYPE', "agency");

class Credibanco
{
    public $currency_code2num = array(
        'USD' => '840',
        'UAH' => '980',
        'RUB' => '643',
        'RON' => '946',
        'KZT' => '398',
        'KGS' => '417',
        'JPY' => '392',
        'GBR' => '826',
        'EUR' => '978',
        'CNY' => '156',
        'BYR' => '974',
        'BYN' => '933'
    );

    public $taxSystem;
    public $taxType;
    public $discountHelper;

    public $test_url = RBS_CREDIBANCO_TEST_URL;
    public $prod_url = RBS_CREDIBANCO_PROD_URL;

    public $language = 'es';
    public $version = '1.0.0';

    private $login;
    private $password;
    public $mode;
    public $stage;
    private $logging;
    public $currency;

    public function __construct()
    {
        //noop
    }

    private function library($library)
    {
        $file = DIR_SYSTEM . 'library/' . str_replace('../', '', (string)$library) . '.php';

        if (file_exists($file)) {
            include_once($file);
        } else {
            trigger_error('Error: Could not load library ' . $file . '!');
            exit();
        }
    }

    /**
     *
     * @param $property
     * @param $value
     * @return $this
     */
    public function __set($property, $value)
    {
        if (property_exists($this, $property)) {
            $this->$property = $value;
        }
        return $this;
    }

    /**
     *
     * @param string $method
     * @param mixed[] $data
     * @return mixed[]
     */
    public function gateway($method, $data)
    {

        $data['userName'] = $this->login;
        $data['password'] = $this->password;
        $data['language'] = $this->language;

        if ($this->mode == 'test') {
            $action_address = $this->test_url;
        } else {
            $action_address = $this->prod_url;
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $action_address . $method,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_POSTFIELDS => http_build_query($data, '', '&'),
            CURLOPT_HTTPHEADER => array('CMS: OpenCart 3.x', 'Module-Version: ' . $this->version),
        ));

        $response = curl_exec($curl);
        if ($this->logging) {
            $this->logger($action_address, $method, $data, $response);
        }
        $response = json_decode($response, true);
        curl_close($curl);

        return $response;
    }

    /**
     *
     * @param string $url
     * @param string $method
     * @param mixed[] $request
     * @param mixed[] $response
     * @return integer
     */
    private function logger($url, $method, $request, $response)
    {
        $this->library('log');
        $file_name = date("y-m-d") . "_credibanco.log";
        $logger = new Log($file_name);
        $logger->write("CREDIBANCO PAYMENT: " . $url . $method . "\nREQUEST: " . json_encode($request) . "\nRESPONSE: " . $response . "\n\n");
    }

    /**
     * @param string $orderId
     * @return mixed[]
     */
    public function get_order_status($orderId)
    {
        return $this->gateway('getOrderStatusExtended.do', array('orderId' => $orderId));
    }
}